<?php
// If uninstall not called from WordPress, exit.
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
    exit;
}

// Only remove data when explicitly opted-in via option or filter.
$opt_in = (bool) get_option( 'rcp_delete_data_on_uninstall', false );
$should_delete = (bool) apply_filters( 'rcp_api_delete_data', $opt_in );

if ( ! $should_delete ) {
    return;
}

// Load core plugin file to access constants/classes if available.
// Guard in case paths differ when running uninstall.
if ( ! defined( 'RCP_API_PLUGIN_DIR' ) ) {
    define( 'RCP_API_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
}

// Known options to delete.
$options = [
    'rcp_feed_username',
    'rcp_feed_password',
    'rcp_category_mapping',
    'rcp_import_featured_image',
    'rcp_enable_auto_publish',
    'rcp_enable_auto_draft',
    'rcp_auto_publish_cats',
    'rcp_auto_draft_cats',
    'rcp_category_automation',
    'rcp_category_authors',
    'rcp_featured_image_cats',
    'rcp_auto_import_frequency',
    'rcp_last_auto_import',
    'rcp_last_successful_import',
    'rcp_cron_last_heartbeat',
    'rcp_category_cutoffs',
    'rcp_plugin_version',
    'rcp_auto_import_log',
    'rcp_deleted_posts',
    'rcp_debug_mode',
    // Error handler options
    'rcp_api_error_log',
    'rcp_api_error_email_queue',
];

foreach ( $options as $opt ) {
    delete_option( $opt );
}

// Remove cache version options created by the cache manager.
global $wpdb;
$wpdb->query( $wpdb->prepare( "DELETE FROM {$wpdb->options} WHERE option_name LIKE %s", 'rcp_cache_version_%' ) );

// Optionally drop plugin tables.
$drop_tables = (bool) apply_filters( 'rcp_api_delete_tables', true );
if ( $drop_tables ) {
    if ( ! class_exists( 'RCP_API_Database_Manager' ) ) {
        $file = RCP_API_PLUGIN_DIR . 'includes/class-rcp-api-database-manager.php';
        if ( file_exists( $file ) ) {
            require_once $file;
        }
    }
    if ( class_exists( 'RCP_API_Database_Manager' ) ) {
        RCP_API_Database_Manager::drop_tables();
    }
}

