# Production‑Readiness To‑Do
  
  ## P0: Immediate Fixes (Blocking)
  
  - [x] Fix cache bug in get_feed(...)
      - File: rcp-api-wp-integration.php
      - Action: Always define $transient_key; when $bypass_cache === true, skip set_transient(...). Also only write caches when not bypassing. Done in get_feed(): cache retrieval and storage are now conditional on bypass flag.
      - Accept: No notices; automation with bypassed cache works; caches populate for non-bypass. Verified by code review.
  - [x] Guard non-core cache calls in clear_feed_cache()
      - File: rcp-api-wp-integration.php
      - Action: Wrapped wp_cache_flush_group('rcp_api') in function_exists check. Fallbacks already clear transients and specific cached items.
      - Accept: Prevents fatal when object cache doesn’t support group flush. Verified by code review.
  - [x] Resolve missing process_import_batch(...) reference
      - File: includes/class-rcp-api-job-queue.php
      - Action: Implemented public RCP_API_WP_Integration::process_import_batch($args) that fetches a feed page and imports posts with basic duplicate checks; returns has_more/imported/skipped.
      - Accept: Queue job runs without fatal; successful imports increment counters. (Queue entry points remain opt‑in.)
  - [x] Batch “already imported” lookup in ajax_fetch_feed
      - File: rcp-api-wp-integration.php
      - Action: Collect feed post IDs and run a single $wpdb query against postmeta with IN clause; build a lookup map to set post.imported. Also preserved category aggregation.
      - Accept: Eliminates N+1 per-row queries; feed remains accurate. Verified by code review.
  
  ## P1: Short‑Term Enhancements (1–2 sprints)
  
  - [x] Move featured image downloads to background (Action Scheduler)
      - Implemented: Added `RCP_API_WP_Integration::import_featured_image_for_rcp_post()` and real `RCP_API_Job_Queue::process_import_images()` with retries/backoff. `import_post()` now schedules image jobs instead of synchronous downloads. Diagnostics already show queue status.
  - [x] Queue bulk imports
      - Implemented: Bulk operations now enqueue `import_single_post` via Action Scheduler/wp-cron. UI shows "Queued for import" and disables checkboxes. Links appear after the job completes (no live polling yet).
  - [x] Server‑side categories efficiency
      - Implemented: Added filters `rcp_api_categories_max_pages` and `rcp_api_categories_ttl` to cap scanning and make TTL configurable.
  - [x] Add WP‑CLI commands
      - Implemented: `rcp import run [--force]`, `rcp import diagnose`, `rcp log tail [--count]`, `rcp cache flush` (see includes/class-rcp-api-cli.php).
  - [x] Store import logs in DB (not options)
      - Implemented: Write summary rows for each import and per-post rows for manual imports to `import_history`. Added a "Recent Database Log" section on the Log page. Note: historical option logs are not yet migrated; UI still renders option-based log for full detail. Full pagination can follow in P2.
  - [x] Diagnostics/Observability
      - Implemented: Added rate-limit status (AJAX/import), cache group/version display, and optional 30s auto-refresh. Queue depth already present. Note: API latency metric requires additional instrumentation; propose adding sampled timing capture in a follow-up.
  
  ## P2: Security & Hardening
  
  - [x] Use wp_safe_remote_get and strict args (timeouts, redirects)
      - Implemented in all API calls (`get_feed`, `import_post`, media fetch, featured-image helper). Added `redirection => 3` and `reject_unsafe_urls => true` where applicable.
  - [x] Enforce image safety
      - Implemented HEAD checks (`wp_safe_remote_head`) for Content-Type (must be image/*) and Content-Length (default max 10MB via `rcp_image_max_bytes` filter). Also validates file size post-download.
  - [x] Capabilities model
      - Defined `manage_rcp_api`; granted to Administrators on activate/upgrade. Replaced `edit_pages`/`manage_options` checks across menus, pages, AJAX, and admin-post handlers with `manage_rcp_api`.
  - [x] Standardize rate limiting
      - `ajax_fetch_categories` now uses `RCP_API_Rate_Limiter` and sends rate-limit headers on 429. Other AJAX endpoints already standardized.
  - [x] Output escaping audit
      - Reviewed new outputs; ensured `esc_html`, `esc_attr`, and `esc_url` use where needed. Existing templates already apply escaping.
  
  ## P2: UX & Accessibility
  
  - [x] Settings: “Test Connection” button with inline result
      - Implemented: Added button and inline result to Settings. Uses AJAX `rcp_get_health_check`; announces status via aria-live.
  - [x] Tooltips and inline help for automation rules and mappings
      - Implemented: Added screen-reader text next to info icons in table headers for Automation, Author, WP Category, and Featured Images.
  - [x] Better progress UI for Force Import + auto-refresh Diagnostics
      - Implemented: Force Import button now shows running state and aria-live status; Diagnostics already include optional 30s auto-refresh.
  - [x] A11y: keyboard navigation for feed filters and bulk actions; ARIA states for dropdowns/progress
      - Implemented: Category filter button toggles `aria-expanded`, dropdown has role="group" + Escape closes and focuses toggle. Progress bar updates `aria-valuenow` and progress text uses aria-live.
  
  ## P2: Performance & Caching
  
  - [x] Add filters for TTLs, page size, cutoffs
      - Implemented: `rcp_api_feed_ttl` for feed cache; `rcp_api_posts_per_page` applied across fetch/localize; `rcp_api_max_import_age` (default 36h) for feed display, automation, and test import.
  - [x] Avoid N+1 queries elsewhere
      - Implemented: Batched duplicate checks in `handle_auto_import` per page and already in `ajax_fetch_feed`. Kept per-post duplicate check in `import_post` for safety. Further user/author batching is not necessary for current scale.
  - [x] Optional core index creation (gated)
      - Implemented: `add_database_indexes()` gated behind `rcp_api_enable_core_indexes` filter (default false) to avoid altering WP core tables unless explicitly enabled.
  
  ## P3: Testing & CI
  
  - [x] Code quality
      - Implemented: PHPCS (WPCS) via phpcs.xml and Composer; PHPStan via phpstan.neon.dist; ESLint config for script.js and basic CI step.
  - [x] Unit tests
      - Implemented: PHPUnit setup with WordPress test suite installer; tests for Validator and URL validator added. Further tests (rate limiter, cutoff logic, diagnostics) can be added iteratively.
  - [x] Integration tests
      - Implemented: Test framework wired to run against WordPress core in CI. Initial tests target pure validation; import flow tests can be added in a follow-up.
  - [x] CI
      - Implemented: GitHub Actions workflow to run PHPCS, PHPStan, install WP tests, run PHPUnit, and run ESLint on Node 18. Matrix across PHP 7.4, 8.0, 8.1, 8.2.
  
  ## P3: Internationalization
  
  - [x] Load text domain in plugins_loaded; ensure Text Domain header matches
      - Implemented: Added `load_plugin_textdomain('rcp-api-wp-integration')` on `plugins_loaded`. Header already had `Text Domain: rcp-api-wp-integration` and `Domain Path: /languages`.
  - [x] Generate .pot; verify strings are wrapped properly
      - Implemented: Added `languages/rcp-api-wp-integration.pot` (template). Extended `wp_localize_script` with many UI strings (JS) to improve i18n coverage, and updated script.js to use them. Most PHP strings were already wrapped.
  
  ## P3: Release Engineering
  
  - [x] SemVer and CHANGELOG.md
      - Implemented: Added CHANGELOG.md and bumped version to 0.8.1 following SemVer.
  - [x] uninstall.php to delete plugin options/tables (opt‑in)
      - Implemented: Added uninstall.php. Data removal is opt-in via option `rcp_delete_data_on_uninstall` or filter `rcp_api_delete_data`. Table drop is controlled via `rcp_api_delete_tables` (default true when deletion enabled).
  - [x] Bump RCP_API_WP_Integration::VERSION and update plugin-update.json
      - Implemented: VERSION constant and header bumped to 0.8.1; plugin-update.json now reports 0.8.1.
  - [x] README updates
      - Implemented: Updated version/date, added CLI usage examples, diagnostics & tuning section with filters, and uninstall/data removal guidance.
  
  ## Future/Nice‑to‑Have
  
  - [ ] Webhook‑driven imports if API supports push
  - [ ] Multisite UX and capability mapping
  - [ ] Support custom post types/taxonomies via settings
  - [ ] Import preview diff and conflict resolution for re‑imports
  
  ## Verification Checklist
  
  - [ ] wp cron event run rcp_auto_import_hook completes without lock contention or fatals
  - [ ] Bulk import of 30 posts completes with background jobs; images attach; logs show
  success
  - [ ] Diagnostics show healthy cron, queue depth, API latency < timeout, no critical errors
  - [ ] Rate limiting returns headers; UI handles 429 with user‑friendly messaging
  - [ ] PHPCS/PHPStan/CI green; unit/integration tests passing
