<?php

class Tests_Validator extends WP_UnitTestCase {

    public function test_validate_integer_ok() {
        $this->assertSame( 5, RCP_API_Validator::validate( 'page', '5' ) );
    }

    public function test_validate_integer_bounds() {
        $this->expectException( RCP_API_Validation_Exception::class );
        RCP_API_Validator::validate( 'page', '0' );
    }

    public function test_validate_enum_status() {
        $this->assertSame( 'publish', RCP_API_Validator::validate( 'status', 'publish' ) );
        $this->expectException( RCP_API_Validation_Exception::class );
        RCP_API_Validator::validate( 'status', 'trash' );
    }

    public function test_validate_datetime_window() {
        $now = current_time( 'timestamp' );
        $in_range = gmdate( 'Y-m-d H:i:s', $now - HOUR_IN_SECONDS );
        $this->assertNotEmpty( RCP_API_Validator::validate( 'post_date', $in_range ) );

        $too_future = gmdate( 'Y-m-d H:i:s', $now + 2 * YEAR_IN_SECONDS );
        $this->expectException( RCP_API_Validation_Exception::class );
        RCP_API_Validator::validate( 'post_date', $too_future );
    }
}

