<?php

class Tests_URL_Validator extends WP_UnitTestCase {

    public function test_validate_url_basic_http_https() {
        $this->assertNotEmpty( RCP_API_Validator::validate_url( 'https://example.com/path' ) );
        $this->assertNotEmpty( RCP_API_Validator::validate_url( 'http://example.com/path' ) );
    }

    public function test_validate_url_invalid_scheme() {
        $this->expectException( RCP_API_Validation_Exception::class );
        RCP_API_Validator::validate_url( 'ftp://example.com' );
    }

    public function test_validate_url_reject_private_ip() {
        $this->expectException( RCP_API_Validation_Exception::class );
        // This should resolve to a private IP and be rejected
        RCP_API_Validator::validate_url( 'http://127.0.0.1/file.jpg' );
    }

    public function test_validate_url_allows_subdomains_when_host_matches() {
        $this->assertNotEmpty( RCP_API_Validator::validate_url( 'https://cdn.example.com/file.jpg', 'example.com' ) );
    }

    public function test_validate_url_rejects_unapproved_domains() {
        $this->expectException( RCP_API_Validation_Exception::class );
        RCP_API_Validator::validate_url( 'https://not-example.com/file.jpg', 'example.com' );
    }

    public function test_validate_url_accepts_multiple_allowed_hosts() {
        $allowed = [ 'primary.example.com', 'fallback.example.net' ];
        $this->assertNotEmpty( RCP_API_Validator::validate_url( 'https://assets.fallback.example.net/file.jpg', $allowed ) );
    }
}
