<?php

class Tests_AI_Log_Trim extends WP_UnitTestCase {

    public function test_ai_image_log_trim_cap() {
        $integration = new RCP_API_WP_Integration();
        delete_option('rcp_ai_image_log');
        // Add > 210 entries
        for ($i = 0; $i < 210; $i++) {
            $integration->record_ai_image_log([
                'time' => current_time('timestamp', true) - (210 - $i),
                'post_id' => 1000 + $i,
                'status' => 'queued',
            ]);
        }
        $log = get_option('rcp_ai_image_log', []);
        $this->assertIsArray($log);
        $this->assertLessThanOrEqual(200, count($log), 'Log should be trimmed to last 200 entries');
    }
}

