<?php

class Tests_AI_Credits_Base extends WP_UnitTestCase {

    public function test_get_credits_api_base_https_and_path() {
        $integration = new RCP_API_WP_Integration();

        // Use reflection to set api_base and access private method
        $ref = new ReflectionClass($integration);
        $prop = $ref->getProperty('api_base');
        $prop->setAccessible(true);
        $prop->setValue($integration, 'http://app.radiocontentpro.com/wp-json/rcp/v1');

        $method = $ref->getMethod('get_credits_api_base');
        $method->setAccessible(true);
        $base = $method->invoke($integration);

        $this->assertStringStartsWith('https://', $base, 'Credits base should enforce HTTPS');
        $this->assertStringEndsWith('/wp-json/rcp-ai-credits/v1', $base, 'Credits base should point to rcp-ai-credits/v1');
    }
}

