#!/usr/bin/env bash
# Copied from the WordPress core test suite installer (simplified)

if [ $# -lt 3 ]; then
  echo "usage: $0 <db-name> <db-user> <db-pass> [db-host] [wp-version]"
  exit 1
fi

DB_NAME=$1
DB_USER=$2
DB_PASS=$3
DB_HOST=${4-localhost}
WP_VERSION=${5-latest}
WP_TESTS_DIR=${WP_TESTS_DIR-/tmp/wordpress-tests-lib}
WP_CORE_DIR=${WP_CORE_DIR-/tmp/wordpress/}

set -ex

download() {
  if command -v curl >/dev/null; then
    curl -sSL "$1" -o "$2"
  elif command -v wget >/dev/null; then
    wget -q -O "$2" "$1"
  fi
}

install_wp() {
  if [ -d "$WP_CORE_DIR" ]; then
    return;
  fi

  mkdir -p "$WP_CORE_DIR"

  if [ "$WP_VERSION" = 'latest' ]; then
    local ARCHIVE_NAME='latest'
  else
    local ARCHIVE_NAME="wordpress-$WP_VERSION"
  fi

  download https://wordpress.org/${ARCHIVE_NAME}.tar.gz /tmp/wordpress.tar.gz
  tar --strip-components=1 -zxmf /tmp/wordpress.tar.gz -C "$WP_CORE_DIR"
}

install_test_suite() {
  # portable in-place argument for both GNU sed and Mac OSX sed
  if [[ $(uname -s) == 'Darwin' ]]; then
    local ioption='-i .bak'
  else
    local ioption='-i'
  fi

  mkdir -p "$WP_TESTS_DIR"
  cd "$WP_TESTS_DIR"

  if [ ! -f wp-tests-config.php ]; then
    download https://develop.svn.wordpress.org/trunk/tests/phpunit/includes/bootstrap.php includes/bootstrap.php
    download https://develop.svn.wordpress.org/trunk/wp-tests-config-sample.php wp-tests-config.php
    sed $ioption "s:dirname( __FILE__ ) . '/src/':'$WP_CORE_DIR':" wp-tests-config.php
    sed $ioption "s/youremptytestdbnamehere/$DB_NAME/" wp-tests-config.php
    sed $ioption "s/yourusernamehere/$DB_USER/" wp-tests-config.php
    sed $ioption "s/yourpasswordhere/$DB_PASS/" wp-tests-config.php
    sed $ioption "s|localhost|$DB_HOST|" wp-tests-config.php
  fi
}

install_db() {
  # parse DB_HOST for port or socket references
  local PARTS=(${DB_HOST//\:/ })
  local DB_HOSTNAME=${PARTS[0]}
  local DB_SOCKORT=${PARTS[1]}
  local EXTRA=()

  if ! [ -z $DB_HOSTNAME ] ; then
    if [ $(echo $DB_SOCKORT | grep -e '^[0-9]\{1,\}$') ]; then
      EXTRA+=( "--host=$DB_HOSTNAME" "--port=$DB_SOCKORT" "--protocol=TCP" )
    elif ! [ -z $DB_SOCKORT ] ; then
      EXTRA+=( "--socket=$DB_SOCKORT" )
    elif ! [ -z $DB_HOSTNAME ] ; then
      EXTRA+=( "--host=$DB_HOSTNAME" --protocol=TCP )
    fi
  fi

  mysqladmin create $DB_NAME --user="$DB_USER" --password="$DB_PASS" ${EXTRA[@]} || true
}

install_wp
install_test_suite
install_db

