jQuery(function($){
    var currentPage = 1;
    var totalPagesCount = 1;
    var totalPosts = 0;
    var apiTotalPages = 1;
    var selectedCategories = [];
    var allCategories = [];
    var isLoading = false;
    try {
        selectedCategories = JSON.parse(sessionStorage.getItem('rcp_selected_categories')) || [];
    } catch(e) {}

    function saveSelected(){
        var selected = $('#rcp-categories input[type="checkbox"]:checked').map(function(){
            return $(this).val();
        }).get();
        try {
            sessionStorage.setItem('rcp_selected_categories', JSON.stringify(selected));
        } catch(e) {}
    }

    var categoriesLoaded = false;
    var categoriesLoading = false;

    function renderCategories(categories){
        categories.sort(function(a,b){ return a.localeCompare(b); });
        var $container = $('#rcp-categories');
        $container.empty();
        $container.attr('role', 'group').attr('aria-label', 'RCP categories');

        var $options = $('<div/>', { id: 'rcp-cat-options' });
        $('<a/>', { id: 'rcp-select-all', href: '#' }).text(RCPFeed.select_all || 'Select All').appendTo($options);
        $options.append(' | ');
        $('<a/>', { id: 'rcp-deselect-all', href: '#' }).text(RCPFeed.deselect_all || 'Deselect All').appendTo($options);
        $container.append($options);

        $.each(categories, function(i, cat){
            var $label = $('<label/>');
            var $checkbox = $('<input/>', { type:'checkbox', value:cat });
            if(selectedCategories.indexOf(cat) !== -1){
                $checkbox.prop('checked', true);
            }
            $label.append($checkbox).append(' ').append(document.createTextNode(cat));
            $container.append($label);
        });
        $container.hide();
        categoriesLoaded = true;
    }

    function loadCategoriesOnDemand() {
        if (categoriesLoaded || categoriesLoading) {
            return;
        }
        
        categoriesLoading = true;
        $('#rcp-category-toggle').text(RCPFeed.loading_categories || 'Loading categories...');
        
        $.get(RCPFeed.ajax_url, {
            action: 'rcp_fetch_categories',
            nonce: RCPFeed.nonce
        }, function(resp) {
            categoriesLoading = false;
            $('#rcp-category-toggle').text('Filter RCP posts by category...');
            
            if (resp.success && resp.data.categories) {
                renderCategories(resp.data.categories);
                $('#rcp-categories').show();
            } else {
                alert((RCPFeed.load_categories_failed || 'Failed to load categories:') + ' ' + (resp.data || 'Unknown error'));
            }
        }).fail(function() {
            categoriesLoading = false;
            $('#rcp-category-toggle').text('Filter RCP posts by category...');
            alert(RCPFeed.network_error_categories || 'Failed to load categories due to network error');
        });
    }

    function formatDate(dateStr){
        if(!dateStr){
            return '';
        }
        var d = new Date(dateStr);
        if(isNaN(d.getTime())){
            return dateStr;
        }
        return d.toLocaleString();
    }

function sortByPublishedDesc(a,b){
        var da = new Date(a.published || a.date || 0);
        var db = new Date(b.published || b.date || 0);
        return db - da;
    }

function filterPosts(data){
        var arr = data.filter(function(post){
            var hasTitle = post.blog_post_title && post.blog_post_title.toString().trim();
            var hasHtml = post.blog_post_html && post.blog_post_html.toString().trim();
            if(!hasTitle || !hasHtml){
                return false;
            }
            if(selectedCategories.length){
                var names = [];
                if(post.categories){
                    $.each(post.categories, function(_, c){ names.push(c.name); });
                }
                return names.some(function(n){ return selectedCategories.indexOf(n) !== -1; });
            }
            return true;
        });
        arr.sort(sortByPublishedDesc);
        return arr;
    }

    function showLoading() {
        isLoading = true;
        $('#rcp-feed tbody').html('<tr><td colspan="6"><div class="rcp-loading">' + (RCPFeed.loading_label || 'Loading...') + '</div></td></tr>');
        $('#rcp-refresh').prop('disabled', true).text(RCPFeed.loading_label || 'Loading...');
    }

    function hideLoading() {
        isLoading = false;
        $('#rcp-refresh').prop('disabled', false).text(RCPFeed.refresh_feed_label || 'Refresh Feed');
    }

function collectCategories(data){
        var set = {};
        $.each(data, function(_, post){
            if(post.categories){
                $.each(post.categories, function(_, c){ if(c && c.name){ set[c.name] = true; } });
            }
        });
        return Object.keys(set);
    }

function renderPosts(posts){
        var $tbody = $('#rcp-feed tbody');
        $tbody.empty();
        $.each(posts, function(i, post){
            var cats = [];
            if(post.categories){
                $.each(post.categories, function(j, c){
                    var name = c.name;
                    if(RCPFeed.mapping && RCPFeed.mapping[name]){
                        name += ' \u2192 ' + RCPFeed.mapping[name].name;
                    }
                    cats.push(name);
                });
            }
            var title = (post.blog_post_title && post.blog_post_title.trim()) ?
                post.blog_post_title :
                ((post.title && (post.title.rendered || post.title)) || '');

            var $tr = $('<tr/>').attr('data-id', post.id).attr('data-published', post.published || '');
            var $checkbox = $('<input/>', { type: 'checkbox', value: post.id });
            
            // Disable checkbox if post is already imported
            if (post.imported) {
                $checkbox.prop('disabled', true);
            }
            
            $('<th/>', { scope: 'row', 'class': 'check-column' })
                .append($checkbox)
                .appendTo($tr);

            $('<td/>', { 'class': 'title column-title' })
                .append($(document.createElement('strong')).text(title))
                .appendTo($tr);

            $('<td/>').text(cats.join(', ')).appendTo($tr);
            $('<td/>', { 'class': 'rcp-published' }).text(formatDate(post.published)).appendTo($tr);

            var $statusTd = $('<td/>', { 'class': 'rcp-status' });
            
            // Show imported status or action buttons
            if (post.imported) {
                var $aiBtn = $('<button/>', { 'class': 'rcp-ai-generate button button-secondary', text: (RCPFeed.ai_generate || 'Generate AI Image') });
                $aiBtn.attr('data-rcp-id', post.id);
                $statusTd.html('<strong>Already Imported</strong><br/>').append($aiBtn);
            } else {
                $('<button/>', { 'class': 'rcp-publish button', text: 'Publish' }).appendTo($statusTd);
                $statusTd.append(' ');
                $('<button/>', { 'class': 'rcp-draft button', text: 'Create Draft' }).appendTo($statusTd);
            }
            
            $tr.append($statusTd);

            var $linkTd = $('<td/>');
            var $a = $('<a/>', { target: '_blank' }).text('View on RCP');
            if (post.link && /^https?:\/\//i.test(post.link)) {
                $a.attr('href', post.link);
            }
            $linkTd.append($a);
            $tr.append($linkTd);

            $tbody.append($tr);
        });

        $('#rcp-total-posts').text(totalPosts + ' posts');
        $('#rcp-page-num').text(currentPage);
        var $links = $('#rcp-page-links').empty();
        function appendLink(p){
            var $a = $('<a/>', {href:'#', 'class':'rcp-page-link', 'data-page':p}).text(p);
            if(p === currentPage){ $a.addClass('current'); }
            $links.append($a).append(' ');
        }
        if(totalPagesCount <= 6){
            for(var i=1;i<=totalPagesCount;i++){ appendLink(i); }
        }else{
            for(var i=1;i<=4;i++){ appendLink(i); }
            $links.append('&hellip; ');
            appendLink(totalPagesCount);
        }
        $('#rcp-prev').prop('disabled', currentPage === 1);
        $('#rcp-next').prop('disabled', currentPage >= totalPagesCount);
    }

    function loadFeed(page){
        page = page || 1;
        currentPage = page;
        
        if(isLoading) return;
        
        showLoading();

        var params = {
            action: 'rcp_fetch_feed',
            nonce: RCPFeed.nonce,
            page: page
        };

        // Add category filter if selected
        if(selectedCategories.length > 0) {
            params.categories = selectedCategories.slice();
        }

        $.get(RCPFeed.ajax_url, params, function(resp){
            hideLoading();
            if(resp.success){
                totalPosts = resp.data.total || 0;
                totalPagesCount = resp.data.total_pages || 1;
                apiTotalPages = resp.data.total_pages || 1;
                
                // Update categories only if they changed
                var newCategories = resp.data.categories || [];
                if(JSON.stringify(allCategories) !== JSON.stringify(newCategories)) {
                    allCategories = newCategories;
                    renderCategories(allCategories);
                }
                
                renderPosts(resp.data.posts || []);
                // Update bulk actions UI after rendering posts
                updateSelectedCount();
                
                // Debug: Check if bulk actions are set up
                if ($('#rcp-bulk-actions').length === 0) {
                    console.error('Bulk actions container missing after feed load!');
                } else {
                    console.log('Bulk actions container found');
                }
            } else {
                var $errTr = $('<tr/>');
                $('<td/>', { colspan: 6 }).text(resp.data || 'Error loading feed').appendTo($errTr);
                $('#rcp-feed tbody').empty().append($errTr);
            }
        }).fail(function(xhr, status, error) {
            hideLoading();
            var $errTr = $('<tr/>');
            var errorMsg = 'Network error: ' + (error || 'Unknown error');
            if(xhr.status === 429) {
                errorMsg = 'Too many requests. Please wait a moment and try again.';
            }
            $('<td/>', { colspan: 6 }).text(errorMsg).appendTo($errTr);
            $('#rcp-feed tbody').empty().append($errTr);
        });
    }

    $(document).on('change', '#rcp-categories input[type="checkbox"]', function(){
        saveSelected();
        selectedCategories = $('#rcp-categories input[type="checkbox"]:checked').map(function(){return $(this).val();}).get();
        loadFeed(1);
    });

    $(document).on('click', '#rcp-select-all', function(e){
        e.preventDefault();
        $('#rcp-categories input[type="checkbox"]').prop('checked', true);
        saveSelected();
        selectedCategories = $('#rcp-categories input[type="checkbox"]').map(function(){return $(this).val();}).get();
        loadFeed(1);
    });

    $(document).on('click', '#rcp-deselect-all', function(e){
        e.preventDefault();
        $('#rcp-categories input[type="checkbox"]').prop('checked', false);
        saveSelected();
        selectedCategories = [];
        loadFeed(1);
    });

    $('#rcp-category-toggle').on('click', function(e){
        e.preventDefault();
        var expanded = $(this).attr('aria-expanded') === 'true';
        $(this).attr('aria-expanded', (!expanded).toString());
        if (!categoriesLoaded) {
            loadCategoriesOnDemand();
        } else {
            $('#rcp-categories').toggle();
        }
    });

    // Hide dropdown on Escape, keep button in sync
    $(document).on('keydown', function(e){
        if (e.key === 'Escape') {
            var $dropdown = $('#rcp-categories');
            if ($dropdown.is(':visible')) {
                $dropdown.hide();
                $('#rcp-category-toggle').attr('aria-expanded', 'false').focus();
            }
        }
    });


    $(document).on('click', function(e){
        if(!$(e.target).closest('#rcp-category-container').length){
            $('#rcp-categories').hide();
        }
    });

    $('#rcp-refresh').on('click', function(e){
        e.preventDefault();
        loadFeed(currentPage);
    });
    $('#rcp-next').on('click', function(e){ e.preventDefault(); loadFeed(currentPage+1); });
    $('#rcp-prev').on('click', function(e){ e.preventDefault(); if(currentPage>1) loadFeed(currentPage-1); });
    $(document).on('click', '.rcp-page-link', function(e){
        e.preventDefault();
        var p = parseInt($(this).data('page'),10);
        if(p && p !== currentPage){
            loadFeed(p);
        }
    });

    $('#rcp-feed').on('click', '.rcp-publish, .rcp-draft', function(){
        var row = $(this).closest('tr');
        var status = $(this).hasClass('rcp-publish') ? 'publish' : 'draft';
        $.post(RCPFeed.ajax_url, {
            action: 'rcp_import_post',
            nonce: RCPFeed.nonce,
            post_id: row.data('id'),
            status: status,
            post_date: row.data('published')
        }, function(resp){
            if(resp.success){
                var statusText = resp.data.already_imported ? 'Already Imported' : 'Imported';
                var aiBtn = '<button class="rcp-ai-generate button button-secondary" data-rcp-id="'+row.data('id')+'"'+(resp.data.new_id ? ' data-wp-id="'+resp.data.new_id+'"' : '')+'>'+(RCPFeed.ai_generate || 'Generate AI Image')+'</button>';
                var html = '<strong>' + statusText + '</strong><br>'+
                    '<a href="'+resp.data.edit_link+'" target="_blank">Edit Post</a> | '+
                    '<a href="'+resp.data.view_link+'" target="_blank">'+resp.data.view_label+'</a>'+
                    '<br/>' + aiBtn;
                row.find('.rcp-status').html(html);
                // Disable checkbox and update count after individual import
                row.find('input[type="checkbox"]').prop('checked', false).prop('disabled', true);
                updateSelectedCount();
            }else{
                alert(resp.data);
            }
        });
    });

    // Per-row: Generate AI Image action
    $('#rcp-feed').on('click', '.rcp-ai-generate', function(){
        var $btn = $(this);
        var row = $btn.closest('tr');
        var rcpId = $btn.data('rcp-id');
        var wpId = $btn.data('wp-id') || '';
        $btn.prop('disabled', true).text(RCPFeed.loading_label || 'Loading...');
        $.post(RCPFeed.ajax_url, {
            action: 'rcp_generate_ai_image',
            nonce: RCPFeed.nonce,
            rcp_post_id: rcpId,
            wp_post_id: wpId
        }, function(resp){
            if (resp && resp.success) {
                if (resp.data && resp.data.attached) {
                    row.find('.rcp-status').append('<div><em>'+(RCPFeed.ai_attached || 'AI image attached successfully')+'</em></div>');
                    if (resp.data.thumbnail_html) {
                        row.find('.rcp-status').append('<div class="rcp-ai-thumb">'+resp.data.thumbnail_html+'</div>');
                    }
                } else if (resp.data && resp.data.skipped) {
                    row.find('.rcp-status').append('<div><em>'+(RCPFeed.ai_skipped || 'Post already has a featured image')+'</em></div>');
                    $btn.prop('disabled', false).text(RCPFeed.ai_generate || 'Generate AI Image');
                } else {
                    row.find('.rcp-status').append('<div><em>'+(RCPFeed.ai_queued || 'Queued for image generation')+'</em></div>');
                    $btn.prop('disabled', true).text(RCPFeed.ai_queued_button || 'Queued');
                }
                if (resp.data && resp.data.attached) {
                    $btn.prop('disabled', true).text(RCPFeed.ai_done || 'AI Image Ready');
                }
            } else {
                alert((RCPFeed.ai_failed || 'AI image request failed') + (resp && resp.data ? ': ' + resp.data : ''));
                $btn.prop('disabled', false).text(RCPFeed.ai_generate || 'Generate AI Image');
            }
        }).fail(function(){
            alert(RCPFeed.ai_failed || 'AI image request failed');
            $btn.prop('disabled', false).text(RCPFeed.ai_generate || 'Generate AI Image');
        });
    });
    
    // Bulk actions functionality - define functions before use
    function updateSelectedCount() {
        var count = $('#rcp-feed tbody input[type="checkbox"]:checked').length;
        var totalCheckboxes = $('#rcp-feed tbody input[type="checkbox"]').length;
        console.log('updateSelectedCount: ' + count + ' selected out of ' + totalCheckboxes + ' total');
        
        var postWord = (count === 1 ? (RCPFeed.post_singular || 'post') : (RCPFeed.post_plural || 'posts'));
        $('#rcp-selected-count').text(count + ' ' + postWord + ' ' + (RCPFeed.selected_label || 'selected'));
        
        if (count > 0) {
            console.log('Showing bulk actions');
            $('#rcp-bulk-actions').show();
        } else {
            console.log('Hiding bulk actions');
            $('#rcp-bulk-actions').hide();
        }
    }
    
    function updateSelectAllCheckbox() {
        var total = $('#rcp-feed tbody input[type="checkbox"]').length;
        var checked = $('#rcp-feed tbody input[type="checkbox"]:checked').length;
        var selectAll = $('#rcp-feed thead input[type="checkbox"]');
        
        if (checked === 0) {
            selectAll.prop('checked', false).prop('indeterminate', false);
        } else if (checked === total) {
            selectAll.prop('checked', true).prop('indeterminate', false);
        } else {
            selectAll.prop('checked', false).prop('indeterminate', true);
        }
    }
    
    function getSelectedPosts() {
        var posts = [];
        $('#rcp-feed tbody input[type="checkbox"]:checked').each(function() {
            var row = $(this).closest('tr');
            posts.push({
                id: row.data('id'),
                published: row.data('published'),
                row: row
            });
        });
        return posts;
    }
    
    function handleBulkAction(status) {
        var posts = getSelectedPosts();
        
        if (posts.length === 0) {
            alert(RCPFeed.no_posts_selected || 'No posts selected');
            return;
        }
        
        if (posts.length > 10) {
            var confirmMsg = 'You are about to import ' + posts.length + ' posts as ' + 
                           (status === 'publish' ? 'published posts' : 'drafts') + 
                           '. This may take a while. Continue?';
            if (!confirm(confirmMsg)) {
                return;
            }
        }
        
        processBulkImport(posts, status);
    }
    
    function updateProgress(current, total) {
        var percent = Math.round((current / total) * 100);
        $('.rcp-progress-fill').css('width', percent + '%');
        $('.rcp-progress-fill').attr('aria-valuenow', percent);
        $('#rcp-progress-text').text('Processing ' + current + ' of ' + total + ' posts...');
    }
    
    function completeBulkImport(successful, failed, errors) {
        // Hide progress, enable buttons
        $('#rcp-bulk-progress').hide();
        $('#rcp-bulk-actions button').prop('disabled', false);
        
        // Update selected count
        updateSelectedCount();
        
        // Show summary
        var message = (RCPFeed.import_complete || 'Import complete.') + ' ';
        if (successful > 0) {
            message += successful + ' ' + (RCPFeed.posts_imported_successfully || 'posts imported successfully.') + ' ';
        }
        if (failed > 0) {
            message += failed + ' ' + (RCPFeed.posts_failed_to_import || 'posts failed to import.') + '';
            if (errors.length > 0) {
                message += '\n\n' + (RCPFeed.errors_label || 'Errors:') + '\n' + errors.slice(0, 5).join('\n');
                if (errors.length > 5) {
                    var more = errors.length - 5;
                    var moreTpl = RCPFeed.and_more_errors || ('... and %d more errors.');
                    message += '\n' + moreTpl.replace('%d', more);
                }
            }
        }
        
        alert(message);
    }
    
    function processBulkImport(posts, status) {
        var total = posts.length;
        var current = 0;
        var successful = 0;
        var failed = 0;
        var errors = [];
        
        // Disable buttons and show progress
        $('#rcp-bulk-actions button').prop('disabled', true);
        $('#rcp-bulk-progress').show();
        updateProgress(0, total);
        
        function importNext() {
            if (current >= posts.length) {
                // All done
                completeBulkImport(successful, failed, errors);
                return;
            }
            
            var post = posts[current];
            current++;
            
            updateProgress(current, total);
            
            $.post(RCPFeed.ajax_url, {
                action: 'rcp_import_post',
                nonce: RCPFeed.nonce,
                post_id: post.id,
                status: status,
                post_date: post.published,
                bulk_import: true
            }, function(resp) {
                if (resp.success) {
                    successful++;
                    if (resp.data && resp.data.queued) {
                        post.row.find('.rcp-status').html('<em>' + (RCPFeed.queued_for_import || 'Queued for import') + '</em>');
                    } else if (resp.data) {
                        var statusText = resp.data.already_imported ? 'Already Imported' : 'Imported';
                        var aiBtn = '<button class="rcp-ai-generate button button-secondary" data-rcp-id="'+post.id+'"'+(resp.data.new_id ? ' data-wp-id="'+resp.data.new_id+'"' : '')+'>'+(RCPFeed.ai_generate || 'Generate AI Image')+'</button>';
                        var html = '<strong>' + statusText + '</strong><br>' +
                                  '<a href="' + resp.data.edit_link + '" target="_blank">Edit Post</a> | ' +
                                  '<a href="' + resp.data.view_link + '" target="_blank">' + resp.data.view_label + '</a>' +
                                  '<br/>' + aiBtn;
                        post.row.find('.rcp-status').html(html);
                    } else {
                        post.row.find('.rcp-status').html('<em>' + (RCPFeed.queued || 'Queued') + '</em>');
                    }
                    post.row.find('input[type="checkbox"]').prop('checked', false).prop('disabled', true);
                } else {
                    failed++;
                    errors.push(resp.data || 'Unknown error');
                    post.row.find('.rcp-status').html('<span style="color: #dc3232;">Failed: ' + (resp.data || 'Unknown error') + '</span>');
                }
                
                // Small delay before next import to avoid overwhelming the server
                setTimeout(importNext, 200);
            }).fail(function() {
                failed++;
                errors.push('Network error');
                post.row.find('.rcp-status').html('<span style="color: #dc3232;">Failed: Network error</span>');
                setTimeout(importNext, 200);
            });
        }
        
        // Start the import process
        importNext();
    }
    
    function setupBulkActions() {
        console.log('Setting up bulk actions');
        
        // Verify bulk actions container exists
        if ($('#rcp-bulk-actions').length === 0) {
            console.error('Bulk actions container not found!');
            return;
        }
        
        // Handle select-all checkbox
        $(document).on('change', '#rcp-feed thead input[type="checkbox"]', function() {
            console.log('Select-all checkbox changed');
            var isChecked = $(this).prop('checked');
            $('#rcp-feed tbody input[type="checkbox"]:not(:disabled)').prop('checked', isChecked);
            updateSelectedCount();
        });
        
        // Handle individual checkbox changes
        $(document).on('change', '#rcp-feed tbody input[type="checkbox"]', function() {
            console.log('Individual checkbox changed');
            updateSelectedCount();
            updateSelectAllCheckbox();
        });
        
        // Handle bulk publish button
        $('#rcp-bulk-publish').on('click', function() {
            handleBulkAction('publish');
        });
        
        // Handle bulk draft button
        $('#rcp-bulk-draft').on('click', function() {
            handleBulkAction('draft');
        });
        
        // Handle clear selection button
        $('#rcp-clear-selection').on('click', function() {
            $('#rcp-feed input[type="checkbox"]').prop('checked', false);
            updateSelectedCount();
        });
        console.log('setupBulkActions completed');
    }
    
    if($('#rcp-feed').length){
        console.log('Feed page detected, loading feed and setting up bulk actions');
        loadFeed();
        setupBulkActions();
    }

    if($('#rcp-category-settings-table').length){
        // Extract native title tooltips to custom data and remove native delay
        $('#rcp-category-settings-table th[title]').each(function(){
            var $th = $(this);
            var tip = $th.attr('title');
            if (tip) {
                $th.attr('data-rcp-tip', tip);
                $th.removeAttr('title');
            }
        });

        // Test Connection button
        $('#rcp-test-connection').on('click', function(){
            var $btn = $(this);
            var $out = $('#rcp-connection-result');
            $('#rcp-status-live').text(RCPFeed.testing || 'Testing...');
            $btn.prop('disabled', true).attr('aria-expanded', 'true');
            $out.text(RCPFeed.testing || 'Testing...');
            $.get(RCPFeed.ajax_url, { action: 'rcp_get_health_check', nonce: RCPFeed.nonce }, function(resp){
                $btn.prop('disabled', false).attr('aria-expanded', 'false');
                if (resp.success && resp.data && resp.data.checks && resp.data.checks.api_connection) {
                    var ok = resp.data.checks.api_connection.status === 'pass';
                    $out.text(ok ? (RCPFeed.api_connected || 'Connected') : ((RCPFeed.api_connection_failed || 'Failed:') + ' ' + (resp.data.checks.api_connection.message || 'Unknown error')));
                    $('#rcp-status-live').text(ok ? (RCPFeed.api_connected || 'Connected') : (RCPFeed.api_connection_error || 'Error'));
                } else {
                    $out.text(RCPFeed.api_connection_error || 'Error');
                    $('#rcp-status-live').text(RCPFeed.api_connection_error || 'Error');
                }
            }).fail(function(){
                $btn.prop('disabled', false).attr('aria-expanded', 'false');
                $out.text(RCPFeed.api_network_error || 'Network error');
                $('#rcp-status-live').text(RCPFeed.api_network_error || 'Network error');
            });
        });
        
        // Force import progress feedback
        $('#rcp-force-import-form').on('submit', function(){
            var $btn = $('#rcp-force-import-button');
            $btn.prop('disabled', true).text(RCPFeed.loading_label || 'Loading...');
            $('#rcp-force-import-status').text(RCPFeed.import_in_progress || 'Import in progress...');
            $('#rcp-status-live').text(RCPFeed.force_import_started || 'Force import started');
        });

        // Make the image-options “i” icon clickable to show help
        function toggleImageHelp() {
            var $trigger = $('#rcp-image-info');
            var $details = $('#rcp-image-options-help');
            if (!$trigger.length || !$details.length) return;
            var isOpen = $details.prop('open');
            $details.prop('open', !isOpen);
            $trigger.attr('aria-expanded', (!isOpen).toString());
            if (!isOpen) {
                try { $details[0].scrollIntoView({ behavior: 'smooth', block: 'nearest' }); } catch(e) {}
            }
        }
        $(document).on('click', '#rcp-image-info', function(e){
            e.preventDefault();
            toggleImageHelp();
        });
        $(document).on('keydown', '#rcp-image-info', function(e){
            if (e.key === 'Enter' || e.key === ' ') {
                e.preventDefault();
                toggleImageHelp();
            }
        });

        // Clickable + hover tooltips for all info icons in headers
        var $tip = $('<div/>', { id: 'rcp-tooltip', 'class': 'rcp-tooltip', style: 'display:none;' }).appendTo('body');
        var activeIcon = null;
        function showTipFor($icon){
            var $th = $icon.closest('th');
            var text = $th.attr('data-rcp-tip') || '';
            if (!text) return;
            $tip.text(text).show();
            var off = $icon.offset();
            var top = off.top + $icon.outerHeight() + 6;
            var left = off.left - ($tip.outerWidth()/2) + ($icon.outerWidth()/2);
            $tip.css({ top: top + 'px', left: Math.max(8, left) + 'px' });
            activeIcon = $icon.get(0);
            $icon.attr('aria-expanded', 'true');
        }
        function hideTip(){
            $tip.hide();
            if (activeIcon) {
                $(activeIcon).attr('aria-expanded', 'false');
            }
            activeIcon = null;
        }
        $(document).on('mouseenter focus', '.rcp-info-icon', function(){
            showTipFor($(this));
        });
        $(document).on('mouseleave blur', '.rcp-info-icon', function(){
            if (activeIcon !== this) return;
            hideTip();
        });
        $(document).on('click', '.rcp-info-icon', function(e){
            e.preventDefault();
            e.stopPropagation();
            if (activeIcon === this && $tip.is(':visible')) {
                hideTip();
            } else {
                showTipFor($(this));
            }
        });
        $(document).on('keydown', '.rcp-info-icon', function(e){
            if (e.key === 'Enter' || e.key === ' ') {
                e.preventDefault();
                if (activeIcon === this && $tip.is(':visible')) { hideTip(); } else { showTipFor($(this)); }
            } else if (e.key === 'Escape') {
                hideTip();
            }
        });
        $(document).on('click', function(){ hideTip(); });
    }

    // Bulk generate AI images for imported posts on current page
    $('#rcp-bulk-ai').on('click', function(e){
        e.preventDefault();
        var $btn = $(this);
        var rows = $('#rcp-feed tbody tr');
        var imported = [];
        rows.each(function(){
            var $row = $(this);
            if ($row.find('.rcp-ai-generate').length) {
                imported.push({ id: $row.data('id'), row: $row });
            }
        });
        if (imported.length === 0) {
            alert(RCPFeed.ai_bulk_none || 'No imported posts found on this page.');
            return;
        }
        $btn.prop('disabled', true).text(RCPFeed.ai_bulk_start || 'Queuing AI image generation...');
        var i = 0;
        function next(){
            if (i >= imported.length) {
                $btn.prop('disabled', false).text('Generate AI Images (Imported on page)');
                alert(RCPFeed.ai_bulk_complete || 'AI image generation requests queued.');
                return;
            }
            var item = imported[i++];
            $.post(RCPFeed.ajax_url, {
                action: 'rcp_generate_ai_image',
                nonce: RCPFeed.nonce,
                rcp_post_id: item.id
            }, function(resp){
                if (resp && resp.success) {
                    item.row.find('.rcp-status').append('<div><em>'+(RCPFeed.ai_queued || 'Queued for image generation')+'</em></div>');
                }
                setTimeout(next, 50);
            }).fail(function(){ setTimeout(next, 50); });
        }
        next();
    });
});
