# RCP API WP Integration

**Version**: 0.9.0  
**Last Updated**: September 17, 2025

This plugin imports posts from the Radio Content Pro API into WordPress with enterprise-grade security, performance, and reliability features. All plugin files live in the root directory of this repository.

It talks to the same membership aware REST API described in the **RCP Custom API** docs. All requests are made with a WordPress application password using HTTP Basic authentication.

### Used Endpoints

* `GET /feed` – fetches the latest posts visible to the configured account. Each page returns 30 posts.
* `GET /posts/{id}` – retrieves a single post when the **Publish** or **Create Draft** buttons are clicked.
* `GET /media/{id}` – used internally to download featured images. The plugin now sends the Basic auth header for any requests to the same domain when sideloading these files. When importing posts it first checks several fields for a featured image URL (`featured_image`, `featured_image_url`, etc.) and falls back to this endpoint if needed. Downloaded images are set as the post thumbnail with alt text and caption where available.

The base URL is `https://app.radiocontentpro.com/wp-json/rcp/v1/` and can be changed in the plugin code if the API moves in the future.

## Features (End‑User)

- Feed & pagination: Browse the latest posts (30 per page) with category filters, remembered selections, and original publish dates.
- One‑click import: Import as Published or Draft; bulk import multiple posts with progress tracking.
- Category mapping: Map RCP categories to your WordPress categories and assign default authors per category.
- Image options per category: Choose one of four modes — None, Import from RCP Source, Generate AI image (always), or Import from RCP Source, else AI.
- AI Images dashboard: See credit balance, buy credits, review recent image jobs, retry failures, and run bulk generation for imported posts.
- Automation: Schedule imports every 15/30/60 minutes and preview the next run from Settings.
- Visibility & logs: Review the last 48 hours in Automation Log; use Diagnostics for connection and cron health.

## Version 0.8.0 Enhancements

### Security
* **Comprehensive Input Validation** - All user inputs validated through centralized system
* **SQL Injection Prevention** - All queries use prepared statements
* **Advanced Rate Limiting** - Multi-tier rate limiting with configurable limits
* **SSRF Protection** - Enhanced validation for image downloads

### Performance
* **Job Queue System** - Asynchronous processing with Action Scheduler support
* **Advanced Caching** - Multi-tier caching with Redis/Memcached support
* **Database Optimization** - Custom indexes and migration system
* **Performance Monitoring** - Built-in metrics tracking

### Reliability
* **Structured Error Handling** - Comprehensive error management with severity levels
* **Health Monitoring** - System health checks and diagnostics
* **Database Migrations** - Version-controlled schema updates
* **Graceful Degradation** - Fallback mechanisms for all critical systems


## Private Updates

Place `plugin-update.json` and the zipped plugin file in a directory on your site. The plugin expects the JSON to be hosted at `https://app.radiocontentpro.com/api-plugin/plugin-update.json`. An example JSON looks like:

```json
{
  "name": "RCP API WP Integration",
  "slug": "rcp-api-wp-integration",
  "version": "0.8.0",
  "download_url": "https://app.radiocontentpro.com/api-plugin/rcp-api-wp-integration.zip",
  "icons": {
    "1x": "https://app.radiocontentpro.com/wp-content/uploads/2025/07/Radio-Content-Pro-WordPress-plugin-image.jpg",
    "2x": "https://app.radiocontentpro.com/wp-content/uploads/2025/07/Radio-Content-Pro-WordPress-plugin-image.jpg"
  }
}
```

Upload both files to `https://app.radiocontentpro.com/api-plugin/` and update the version and ZIP when releasing new versions.

This plugin includes the [Plugin Update Checker](https://github.com/YahnisElsts/plugin-update-checker) library to fetch update information from the JSON file and display update notices inside WordPress.

## System Requirements

* WordPress 5.8 or higher
* PHP 7.4 or higher
* MySQL 5.7 or higher / MariaDB 10.2 or higher
* WordPress Application Password support
* Recommended: Action Scheduler plugin for optimal job queue performance
* Recommended: Redis or Memcached for object caching
* Recommended: 256MB+ PHP memory limit for large imports

## CLI Usage (optional)

Once the plugin is active and WP-CLI is installed on your server, you can:

```
# Run the importer immediately (respects cutoffs)
wp rcp import run

# Force a larger backfill (ignores cutoffs)
wp rcp import run --force

# View diagnostics summary (cron, last run, queue)
wp rcp import diagnose

# Tail recent logs (option log and DB history)
wp rcp log tail --count=20

# Flush plugin caches (object cache + transients)
wp rcp cache flush

# AI credits balance
wp rcp ai balance

# Queue AI generation for a specific imported post
wp rcp ai generate --post=123

# Queue AI generation for imported posts missing thumbnails (optionally constrained by date)
wp rcp ai generate --missing-thumbnails --since=2025-09-01

# Show recent AI image jobs from the local log
wp rcp ai jobs --status=success --limit=10
```

## Diagnostics & Tuning (optional)

The Diagnostics page shows cron health, last run times, rate-limit status, and cache stats. You can also enable optional auto-refresh.

Advanced tuning via filters (add in a small mu-plugin or theme functions.php):

```
// Set feed/page size to 50
add_filter('rcp_api_posts_per_page', function(){ return 50; });

// Change import window to 24h
add_filter('rcp_api_max_import_age', function(){ return 24 * HOUR_IN_SECONDS; });

// Increase feed cache TTL to 10 minutes
add_filter('rcp_api_feed_ttl', function(){ return 10 * MINUTE_IN_SECONDS; });

// (Advanced) Allow creating DB indexes on core tables
add_filter('rcp_api_enable_core_indexes', '__return_true');
```

## Uninstall / Data Removal

By default, uninstalling the plugin keeps data. To remove all plugin data and tables on uninstall, set the option `rcp_delete_data_on_uninstall` to true, or filter `rcp_api_delete_data` to return true. Tables can also be retained/removed with the `rcp_api_delete_tables` filter (default true when deletion is enabled).
