# RCP API WordPress Integration Plugin

## Seamlessly Connect Radio Content Pro to WordPress

Transform your content workflow with the RCP API WordPress Integration plugin – the professional solution for radio stations, podcasters, and media organizations who want to automatically sync their Radio Content Pro content with WordPress.

### Why Choose RCP API WordPress Integration?

Stop wasting hours copying and pasting content between platforms. Our plugin creates a direct bridge between Radio Content Pro and WordPress, allowing you to focus on creating great content while we handle the technical details.

**Perfect for:**
- Radio stations publishing show notes and playlists
- Podcast networks managing multiple shows
- News organizations syndicating content
- Multi-author blogs requiring automated workflows
- Any Radio Content Pro user wanting to streamline their publishing process

## Key Features

### 🔄 Automated Content Import
- **Scheduled Imports**: Set up automatic imports every 15, 30, or 60 minutes
- **Smart Filtering**: Only imports posts from the last 36 hours to keep content fresh
- **Category-Specific Rules**: Configure different automation settings per category
- **Duplicate Prevention**: Never worry about importing the same post twice

### 📝 Manual Import Control
- **Browse & Select**: View available posts in a familiar WordPress-style interface
- **Bulk Operations**: Import multiple posts at once as published posts or drafts
- **Preview Before Import**: See post details before bringing them into your site
- **Category Filtering**: Filter the feed by specific categories

### 🏷️ Advanced Category Management
- **Category Mapping**: Map RCP categories to your existing WordPress categories
- **Per-Category Authors**: Assign default authors for each category
- **Featured Image Options**: Per category choose None, Import from RCP Source, Generate AI image (always), or Import from RCP Source, else AI

### 📊 Comprehensive Logging & Diagnostics
- **Import History**: Track all import activities for the last 48 hours
- **Debug Mode**: Enable detailed logging for troubleshooting
- **Performance Metrics**: Monitor import speed and resource usage
- **Error Tracking**: Clear visibility into any import issues

### 🎨 AI Images (Optional)
- **Per-Post Generation**: Click “Generate AI Image” on the Feed for imported posts
- **Per-Category Modes**: Choose AI generation modes per category, including fallback when no RCP image is available
- **Credits-Based**: Uses your RCP credits; balance and purchase link shown in Settings
- **Activity & Retry**: Recent image jobs listed; retry failed/timeouts
- **Bulk Generation**: Generate AI images for imported posts on the current Feed page

## Getting Started

### Installation

1. Download the plugin ZIP file
2. Navigate to **Plugins → Add New** in WordPress admin
3. Click **Upload Plugin** and select the ZIP file
4. Activate the plugin

### Initial Setup

1. **Connect to RCP**
   - Go to **RCP API → API Connection**
   - Enter your Radio Content Pro email
   - Generate and enter a WordPress Application Password
   - Click **Save Settings** and verify the green connection indicator

2. **Configure Categories**
   - Navigate to **RCP API → Settings**
   - Set up category mappings between RCP and WordPress
   - Configure automation rules per category (None/Draft/Publish)
   - Assign default authors for automated imports

3. **Enable Automation** (Optional)
   - Choose import frequency (15, 30, or 60 minutes)
   - Select which categories to automate
   - Save settings to activate scheduled imports

## Settings Guide

### API Connection Settings
- **Username**: Your Radio Content Pro account email
- **Password**: WordPress Application Password (not your regular password)
- **Connection Status**: Green = Connected, Red = Connection Issue

### Automation Settings
- **Import Frequency**: How often to check for new posts
- **Category Rules**: 
  - None = Don't import automatically
  - Draft = Import as draft posts
  - Publish = Import and publish immediately
- **Default Authors**: Assign posts to specific WordPress users

### Advanced Settings
- **Featured Image Options**: Choose per-category mode (None, RCP Source, AI, or RCP Source else AI)
- **AI Images (Optional)**: View balance, buy credits, bulk-generate for imported posts
- **Debug Mode**: Toggle detailed logging for troubleshooting
- **Import Lock**: Prevents concurrent imports from running

## Common Use Cases

### Radio Show Updates
Automatically import and publish show notes, playlists, and episode recaps as they're posted to Radio Content Pro.

### News Syndication
Pull in news updates as drafts for review before publishing, maintaining editorial control while saving time.

### Multi-Author Blogs
Assign different RCP categories to different authors, maintaining proper attribution automatically.

### Content Scheduling
Import posts as drafts and schedule them throughout the day for consistent content flow.

## Frequently Asked Questions

### Connection Issues

**Q: I'm getting a red connection indicator. What should I do?**
A: 
1. Verify your email is correct
2. Generate a new Application Password in WordPress
3. Ensure your Radio Content Pro subscription is active
4. Check that your server can reach radiocontentpro.com

**Q: What's an Application Password?**
A: It's a special password for API access. Generate one in WordPress under Users → Your Profile → Application Passwords. Never use your regular login password.

### Import Problems

**Q: Why aren't my posts importing automatically?**
A: Check these common issues:
1. Verify automation is enabled in Settings
2. Ensure categories have automation rules set (not "None")
3. Check that WordPress cron is running (visit Diagnostics page)
4. Confirm posts exist in the last 36 hours
5. Review the Automation Log for specific errors

**Q: Posts are being imported twice. How do I fix this?**
A: The plugin has built-in duplicate prevention. If you're seeing duplicates:
1. Check if manual and automatic imports are both running
2. Ensure you're running plugin version 0.7.1 or later
3. Clear your import history and start fresh
4. The plugin version 0.7.1+ includes enhanced duplicate prevention

**Q: Can I re-import deleted posts?**
A: 
- Automatic imports will NOT re-import deleted posts for 90 days
- Manual imports from the Feed page CAN re-import deleted posts
- This prevents accidentally deleted content from reappearing

### Content & Formatting

**Q: Why are some posts skipped during import?**
A: Posts are skipped if they:
- Are missing a title
- Have no content (empty blog_post_html)
- Are older than 36 hours
- Were previously deleted from WordPress

**Q: How do featured images work?**
A: Use Settings → Featured Image Options to choose per-category behavior: None, Import from RCP Source, Generate AI image, or Import from RCP Source, else AI.

**Q: What happens to formatting and media in posts?**
A: 
- HTML formatting is preserved
- Inline images remain as external links
- Featured images are downloaded and stored in your Media Library

### Performance & Limitations

**Q: How many posts can I import at once?**
A: 
- Feed displays 30 posts per page
- Bulk import handles up to 30 posts at once
- Large imports (10+) show a confirmation dialog
- Rate limiting prevents server overload

**Q: Is there a limit on automated imports?**
A: No hard limit, but:
- Only posts from the last 36 hours are considered
- Each category maintains its own cutoff time
- Performance depends on your server resources

**Q: Will this slow down my website?**
A: 
- Imports run in the background via WordPress cron
- Caching reduces API calls
- Rate limiting prevents server overload
- Most users see no performance impact

### Troubleshooting

**Q: Where can I see what's happening with imports?**
A: 
1. **Automation Log**: Shows last 48 hours of import activity
2. **Diagnostics Page**: Displays system status and settings
3. **Debug Mode**: Enables detailed logging when needed

**Q: The Force Import button doesn't work. What's wrong?**
A: 
1. Check for an import lock (shown in Diagnostics)
2. Use "Clear Import Lock" if stuck
3. Ensure you have posts in the last 36 hours
4. Verify category automation settings

**Q: How do I completely reset the plugin?**
A: 
1. Deactivate the plugin
2. Delete these options from your database:
   - All options starting with `rcp_`
3. Reactivate and reconfigure

### Advanced Features

**Q: Can I customize which posts are imported?**
A: Yes, through:
- Category filtering
- Time-based cutoffs (36-hour window)
- Manual selection in the Feed page
- Per-category automation rules

**Q: Does the plugin support multiple authors?**
A: Yes! Configure default authors per category in Settings. All imported posts maintain proper attribution.

**Q: Can I modify posts after import?**
A: Absolutely. Once imported, posts are regular WordPress posts. Edit them like any other content.

## Plugin Benefits

### Save Time
- Eliminate manual copy-pasting between systems
- Automate content flow from Radio Content Pro to WordPress
- Bulk import multiple posts with one click
- Set it and forget it with scheduled automation

### Maintain Control
- Choose what gets imported and when
- Review content before publishing with draft mode
- Assign posts to appropriate authors automatically
- Filter by categories to import only what you need

### Stay Organized
- Automatic category mapping keeps content organized
- Comprehensive logs track all import activity
- Clear diagnostics help troubleshoot any issues
- Built-in duplicate prevention avoids content chaos

### Professional Features
- Enterprise-grade security with Application Passwords
- Efficient caching reduces server load
- Rate limiting prevents API abuse
- Debug mode for advanced troubleshooting

## Best Practices

1. **Start with Manual Imports**: Test the connection and mapping before enabling automation
2. **Use Draft Mode Initially**: Import as drafts until you're confident in the setup
3. **Monitor the First Week**: Check logs regularly when first starting
4. **Regular Backups**: Always maintain WordPress backups before bulk imports
5. **Reasonable Frequencies**: 30-minute intervals work well for most sites

## Need More Help?

- **Documentation**: Check the README.md file in the plugin folder
- **Diagnostics**: Use the built-in Diagnostics page for system information
- **Debug Export**: Download debug logs when contacting support
- **Version Check**: Ensure you're running the latest plugin version

## System Requirements

- WordPress 5.8 or higher
- PHP 7.4 or higher
- MySQL 5.7 or higher / MariaDB 10.2 or higher
- Active Radio Content Pro subscription
- Working WordPress cron (or alternative cron setup)
- Outbound HTTPS connections allowed

## Privacy & Security

- Uses WordPress Application Passwords for secure authentication
- All API communications use HTTPS
- No sensitive data is stored in plain text
- Advanced multi-tier rate limiting prevents abuse
- SSRF protection with DNS validation for image downloads
- SQL injection prevention with prepared statements
- Comprehensive input validation system

## New in Version 0.8.0

### Enterprise-Grade Security
- **Input Validation System**: All user inputs validated through centralized system
- **SQL Injection Prevention**: Complete protection with prepared statements
- **Enhanced Rate Limiting**: Configurable limits for different operations
- **SSRF Protection**: DNS resolution validation for all external requests

### Performance at Scale
- **Job Queue System**: Reliable background processing with Action Scheduler
- **Advanced Caching**: Multi-tier caching with Redis/Memcached support
- **Database Optimization**: Custom indexes for lightning-fast queries
- **Performance Monitoring**: Track execution time and resource usage

### Rock-Solid Reliability
- **Structured Error Handling**: Comprehensive error management
- **Health Monitoring**: Built-in diagnostics and health checks
- **Database Migrations**: Version-controlled schema management
- **Graceful Degradation**: Automatic fallbacks for all systems

## Get Started Today

### Download the Plugin

Ready to transform your content workflow? Download the RCP API WordPress Integration plugin and start automating your content publishing today.

**[Download Plugin (Version 0.8.0)](https://radiocontentpro.com/api-plugin/rcp-api-wp-integration.zip)**

### Requirements Check

Before installing, ensure your site meets these requirements:
- ✓ WordPress 5.8 or higher
- ✓ PHP 7.4 or higher
- ✓ Active Radio Content Pro subscription
- ✓ WordPress Application Passwords enabled
- ✓ Working WordPress cron

### Quick Start in 3 Steps

1. **Install & Activate** - Upload the plugin to WordPress
2. **Connect Your Account** - Enter your RCP credentials
3. **Configure & Import** - Set up categories and start importing

### Need Help?

Our comprehensive documentation and diagnostic tools make setup easy, but if you need assistance:
- Check the built-in Diagnostics page
- Review the FAQ section above
- Enable Debug Mode for detailed logging

---

*Current Version: 0.8.2*
*Last Updated: September 17, 2025*

**Transform your content workflow today with RCP API WordPress Integration!**
