# Changelog

All notable changes to this project will be documented in this file.

The format is based on Keep a Changelog and this project adheres to Semantic Versioning (SemVer).

## [0.8.2] - 2025-09-17
### Changed
- Documentation updates and i18n refinements.
- Confirmed author metadata: Radio Content Pro (https://radiocontentpro.com/).

## [0.8.1] - 2025-09-17
### Added
- Job queue integration for featured image imports with retry/backoff.
- WP-CLI commands: `rcp import run [--force]`, `rcp import diagnose`, `rcp log tail [--count]`, `rcp cache flush`.
- Diagnostics: rate-limit status, cache stats, optional 30s auto-refresh.
- Internationalization: localized JS strings; `.pot` template.
- Testing & CI: PHPCS (WPCS), PHPStan, PHPUnit with WP test suite, GitHub Actions.

### Changed
- Batched duplicate detection in automation and feed to avoid N+1 queries.
- Cache TTLs, page size, and import window now filterable.
- Capability model: new `manage_rcp_api` capability; applied across UI/AJAX.
- HTTP requests use `wp_safe_remote_get`/`head` with strict args.

### Fixed
- Prevent fatal when `wp_mail` is unavailable during early error handling by queuing emails and flushing on init.

## [0.8.0] - 2025-07-18
### Initial public release with enterprise-grade enhancements
- Input validation, rate limiting, error handling, caching, diagnostics, and automation features.

[0.8.2]: https://github.com/wphatch/rcp-api-wp-integration/compare/0.8.1...0.8.2
[0.8.1]: https://github.com/wphatch/rcp-api-wp-integration/compare/0.8.0...0.8.1
