# Repository Guidelines

## Project Structure & Module Organization
The plugin boots from `rcp-api-wp-integration.php`, hooking admin menus, cron `rcp_auto_import_hook`, AJAX handlers, and front assets. Business logic lives under `includes/` as `class-rcp-api-*.php` components for validation, rate limiting, job queueing, monitoring, and storage management. Update infrastructure resides in `lib/` (`plugin-update-checker.php`, `Puc/`). Front-end assets are root `script.js`, `style.css`; `assets/` stores static imagery and docs only. Add new integrations beside their peers, keeping naming consistent.

## Build, Test, and Development Commands
Activate locally after copying to `wp-content/plugins/rcp-api-wp-integration` with `wp plugin activate rcp-api-wp-integration`. Validate PHP syntax quickly via `find . -name '*.php' -not -path './.git/*' -print0 | xargs -0 -n1 php -l`. Force an import cycle for debugging with `wp cron event run rcp_auto_import_hook`. Admin tools live at `/wp-admin/admin.php?page=rcp-api-feed`, `...=rcp-api-settings`, and `...=rcp-api-diagnostics`.

## Coding Style & Naming Conventions
Follow WordPress Coding Standards with four-space indentation and snake_case for functions. Prefix classes with `RCP_API_`, functions with `rcp_api_`, and filenames with `class-rcp-api-*.php`. Wrap user-facing strings in `__()` or `esc_html__()` using the `rcp-api-wp-integration` text domain. Escape output, sanitize input, and enforce capability checks plus nonces on admin and AJAX endpoints.

## Testing Guidelines
Automated suites are not yet wired; stage new tests under `tests/` and keep them fast and isolated. Manually verify feed imports, category mapping, featured image handling, and draft versus publish settings. Use the Diagnostics screen to run health checks and inspect logs before shipping.

## Commit & Pull Request Guidelines
Write concise, imperative commit messages; release tags follow `Version X.Y.Z: short summary`. PRs should explain purpose, link issues, document admin UI changes with screenshots, list reproduction steps, and note data migrations or supported WP/PHP versions. Bump `RCP_API_WP_Integration::VERSION` and refresh `plugin-update.json` when releasing.

## Security & Configuration Tips
Store secrets in environment or WordPress settings, never in version control. Prefer logging identifiers rather than PII. Optional tuning flags in `wp-config.php` include `RCP_MAX_IMPORT_BATCH`, `RCP_API_TIMEOUT`, and `RCP_DEBUG_PERFORMANCE`. Enable `WP_DEBUG` during development to exercise the error handler and surface integration issues.
